document.addEventListener("DOMContentLoaded", function(event) {
    function formatRut(rut){
        let tmp = rut.split('-').join('').split('.').join('');
        rut = tmp.substring(0, tmp.length - 1), f = "";
        while(rut.length > 3) {
            f = '.' + rut.substr(rut.length - 3) + f;
            rut = rut.substring(0, rut.length - 3);
        }
        return (rut.trim() == '') ? '' : rut + f + "-" + tmp.charAt(tmp.length-1);
    }
    window.addEventListener("keyup", function(){
        let rut = document.getElementById('rut');
        if(!rut)
        {
            return;
        }
        let tmp = rut.value;
        let format = formatRut(tmp);
        if(!format)
        {
            return;
        }
        rut.value = format;
    });
    var formPasswords = document.querySelectorAll(".form-password-toggle")
    for (var i = 0; i < formPasswords.length; i++) {
        formPasswords[i].querySelector(".eye .off").style.display = 'none';
    }
    function togglePassword()
    {
        let inputId = this.dataset.input;
        let input = document.getElementById(inputId);
        console.log(inputId);
        if (input.type === "password") {
            input.type = "text";
            this.querySelector(".eye .off").style.display = 'block';
            this.querySelector(".eye .on").style.display = 'none';
        } else {
            input.type = "password";
            this.querySelector(".eye .off").style.display = 'none';
            this.querySelector(".eye .on").style.display = 'block';
        }
    }
    var buttonEyes = document.querySelectorAll(".eye");
    for (var i = 0; i < buttonEyes.length; i++) {
        buttonEyes[i].addEventListener("click", togglePassword);
    }
});
