<!DOCTYPE html>

<html
  lang="en"
  class="light-style layout-navbar-fixed layout-menu-fixed"
  dir="ltr"
  data-theme="theme-default"
  data-assets-path="<?= $this->Url->image('/admin/assets/') ?>"
  data-template="vertical-menu-template-starter">
    <head>
        <?= $this->Html->charset() ?>
        <meta
        name="viewport"
        content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
        <title><?= __('Sistema de administración docente') ?></title>
        <meta name="description" content="<?= __('Sistema de administración docente') ?>" />
        <!-- Favicon -->
        <?= $this->Html->meta('icon') ?>
        <!-- Fonts -->
        <?= $this->Html->tag('link', '', [
            'rel' => 'preconnect',
            'href' => 'https://fonts.googleapis.com'
        ]) ?>
        <?= $this->Html->tag('link', '', [
            'rel' => 'preconnect',
            'href' => 'https://fonts.gstatic.com',
            'crossorigin' => 'anonymous'
        ]) ?>
        <?= $this->Html->tag('link', '', [
            'rel' => 'stylesheet',
            'href' => 'https://fonts.googleapis.com/css2?family=Public+Sans:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap'
        ]) ?>
        <?= $this->Html->css([
            '/admin/assets/vendor/fonts/tabler-icons.css',
            '/admin/assets/vendor/css/rtl/core.css',
            '/admin/assets/vendor/css/rtl/theme-default.css',
            '/admin/assets/css/demo.css',
            '/admin/assets/vendor/libs/node-waves/node-waves.css',
            '/admin/assets/vendor/libs/sweetalert2/sweetalert2.css',
            '/admin/assets/vendor/libs/snackbar/snackbar.min.css',
            '/admin/assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.css',
            '/admin/assets/vendor/libs/datatables-bs5/datatables.bootstrap5.css',
            '/admin/assets/vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.css',
            '/admin/assets/vendor/libs/datatables-checkboxes-jquery/datatables.checkboxes.css',
            '/admin/assets/vendor/libs/datatables-buttons-bs5/buttons.bootstrap5.css',
            '/admin/assets/css/custom.css'
        ]) ?>
        <!-- Page CSS -->
        <!-- Helpers -->
        <?= $this->Html->script([
            '/admin/assets/vendor/js/helpers.js',
            '/admin/assets/js/config.js'
        ]) ?>
    </head>
    <body>
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
      <div class="layout-container">
        <!-- Menu -->
        <?= $this->element('admin/menu') ?>
        <!-- / Menu -->
        <!-- Layout container -->
        <div class="layout-page">
        <!-- Navbar -->
        <?= $this->element('admin/navbar') ?>
        <!-- / Navbar -->
        <!-- Content wrapper -->
          <div class="content-wrapper">
             <!-- Content wrapper -->
            <div class="container-xxl pt-4">
                <div class="card">
                    <div class="card-body">
                        <?php
                        $this->Breadcrumbs->setTemplates([
                            'wrapper' => '<nav aria-label="breadcrumb"><ol class="breadcrumb mb-0">{{content}}</ol></nav>',
                            'item' => '<li class="breadcrumb-item"><a href="{{url}}">{{title}}</a></li>',
                            'itemWithoutLink' => '<li class="breadcrumb-item active" aria-current="page">{{title}}</li>',
                        ]);
                        ?>
                        <?php echo $this->Breadcrumbs->render(); ?>
                    </div>
                </div>
            </div>
            <!-- Content -->
            <?= $this->fetch('content') ?>
            <?= $this->element('admin/modal') ?>
            <!-- / Content -->
            <!-- Footer -->
            <?= $this->element('admin/footer') ?>
            <!-- / Footer -->
            <div class="content-backdrop fade"></div>
          </div>
          <!-- Content wrapper -->
        </div>
        <!-- / Layout page -->
      </div>
      <!-- Overlay -->
      <div class="layout-overlay layout-menu-toggle"></div>
      <!-- Drag Target Area To SlideIn Menu On Small Screens -->
      <div class="drag-target"></div>
    </div>
    <?= $this->Html->script([
        '/admin/assets/vendor/libs/jquery/jquery.js',
        '/admin/assets/vendor/libs/popper/popper.js',
        '/admin/assets/vendor/js/bootstrap.js',
        '/admin/assets/vendor/libs/node-waves/node-waves.js',
        '/admin/assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js',
        '/admin/assets/vendor/libs/hammer/hammer.js',
        '/admin/assets/vendor/libs/snackbar/snackbar.min.js',
        '/admin/assets/vendor/libs/sweetalert2/sweetalert2.js',
        '/admin/assets/vendor/js/menu.js',
        '/admin/assets/vendor/libs/datatables-bs5/datatables-bootstrap5.js',
        '/admin/assets/js/main.js',
        '/admin/assets/js/app-config.js',
        '/admin/assets/js/component/button-loading.js',
    ]) ?>
    <script>
    var rootPath = '<?php echo $this->Url->build('/'); ?>';
    var wwwPath = '<?php echo WWW_ROOT; ?>';
    var root = '<?php echo ROOT; ?>';
    var _csrfToken = "<?= $this->request->getCookie('csrfToken') ?>";
    </script>
    <?php
    $js = '/admin/custom/js/'.strtolower($controllerName).'/'.strtolower($actionName).'.js?v='.$versionAdmin;
    $jsPath = WWW_ROOT.'admin/custom/js/'.strtolower($controllerName).'/'.strtolower($actionName).'.js';
    $info = new SplFileInfo($jsPath);
    if($info->isFile())
    {
        echo $this->Html->script($js);
    }
    ?>
    </body>
</html>

