<?php
declare(strict_types=1);

/**
 * CakePHP(tm) : Rapid Development Framework (https://cakephp.org)
 * Copyright (c) Cake Software Foundation, Inc. (https://cakefoundation.org)
 *
 * Licensed under The MIT License
 * For full copyright and license information, please see the LICENSE.txt
 * Redistributions of files must retain the above copyright notice.
 *
 * @copyright Copyright (c) Cake Software Foundation, Inc. (https://cakefoundation.org)
 * @link      https://cakephp.org CakePHP(tm) Project
 * @since     0.2.9
 * @license   https://opensource.org/licenses/mit-license.php MIT License
 */
namespace App\Controller;

use Cake\Controller\Controller;
use Cake\Event\EventInterface;
use Cake\Core\Configure;

/**
 * Application Controller
 *
 * Add your application-wide methods in the class below, your controllers
 * will inherit them.
 *
 * @link https://book.cakephp.org/5/en/controllers.html#the-app-controller
 */
class AppController extends Controller
{
    public $menus = [];
    public $user = null;
    /**
     * Initialization hook method.
     *
     * Use this method to add common initialization code like loading components.
     *
     * e.g. `$this->loadComponent('FormProtection');`
     *
     * @return void
     */
    public function initialize(): void
    {
        parent::initialize();

        $this->loadComponent('Flash');
        $this->loadComponent('Ajax.Ajax');
        $this->loadComponent('Authentication.Authentication');
        $this->menus = Configure::read('menus');

        /*
         * Enable the following component for recommended CakePHP form protection settings.
         * see https://book.cakephp.org/5/en/controllers/components/form-protection.html
         */
        //$this->loadComponent('FormProtection');
    }
    public function beforeFilter(EventInterface $event)
    {
        date_default_timezone_set("America/Santiago");
        $controllerName = $this->request->getParam('controller');
        $actionName = $this->request->getParam('action');
        $passParameters = $this->request->getParam('pass');
        $menu = @$this->menus[1];
        $isSuperAdmin = false;
        $firstUrl = [];
        $user = $this->Authentication->getIdentity();
        if(!empty($user) && !empty($this->menus[$user->role_id]))
        {
            $menu = $this->menus[$user->role_id];
            $this->user = $user;
            if($this->user->role_id == 1)
            {
                $isSuperAdmin = true;
            }
            $firstUrl = $menu[0]['links'][0]['full_url'];
        }
        $versionAdmin = '0.0.1';
        $this->set('controllerName',$controllerName);
        $this->set('actionName',$actionName);
        $this->set('passParameters',$passParameters);
        $this->set('versionAdmin',$versionAdmin);
        $this->set('menu',$menu);
         $this->set('user',$user);
        $this->set('isSuperAdmin',$isSuperAdmin);
        $this->set('firstUrl',$firstUrl);
    }
}
