<?php
declare(strict_types=1);

namespace App\Controller\Admin;
use Cake\Event\EventInterface;
use App\Text\Messages;

use App\Controller\AppController;

/**
 * Users Controller
 *
 * @property \App\Model\Table\UsersTable $Users
 */
class UsersController extends AppController
{
    public $texts;
    public function beforeFilter( EventInterface $event ) {
        parent::beforeFilter( $event );
        $this->viewBuilder()->setLayout('admin/default');
        $this->Authentication->addUnauthenticatedActions(['login','free','qr','forgotPassword', 'resetPassword', 'add', 'index', 'list','edit', 'delete']);
        $this->texts = [
            'article' => __('El'),
            'entity' => __('usuario'),
            'article_lower' => __('el'),
            'gender' => __('ao')
        ];
    }
    /**
     * Index method
     *
     * @return \Cake\Http\Response|null|void Renders view
     */
    public function index()
    {
    }
    public function list(){
        $this->viewBuilder()->setLayout("ajax");
        $users = [];
        if($this->request->is("ajax"))
        {
            $conditions = [];
            $users = $this->Users->find('all',
                [
                    'fields' => [
                        'id',
                        'name',
                        'last_name',
                        'email',
                        'rut',
                        'role_id'
                    ],
                    'conditions' => $conditions,
                    'contain' => [
                        'Roles' => [
                            'fields' => [
                                'Roles.id',
                                'Roles.description',
                            ]
                        ]
                    ]
                ]
            );
        }
        $this->response = $this->response->withType('json');
        $this->response = $this->response->withStringBody(json_encode(["data" => $users]));
        return $this->response;
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $this->viewBuilder()->setClassName('Ajax.Ajax');
        $user = $this->Users->newEmptyEntity();
        $user->active = 1;
        if ($this->request->is('post')) {
            $user = $this->Users->patchEntity($user, $this->request->getData());
            if ($this->Users->save($user))
            {
                $this->Flash->success(Messages::success('add', $this->texts['article'], $this->texts['entity'], $this->texts['gender']));
            }
            else
            {
                $this->Flash->error(Messages::error('add', $this->texts['article_lower'], $this->texts['entity']));
            }
        }
        $roles = $this->Users->Roles->find('list', limit: 200)->all();
        $this->set(compact('user', 'roles'));
    }

    /**
     * Edit method
     *
     * @param string|null $id User id.
     * @return \Cake\Http\Response|null|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $this->viewBuilder()->setClassName('Ajax.Ajax');
        $user = $this->Users->get($id, contain: []);
        unset($user->password);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $data = $this->request->getData();
            if(!isset($data['password']) || empty($data['password']))
            {
                unset($data['password']);
            }
            $user = $this->Users->patchEntity($user, $data);
            if ($this->Users->save($user))
            {
                $this->Flash->success(Messages::success('edit', $this->texts['article'], $this->texts['entity'], $this->texts['gender']));
            }
            else
            {
                $this->Flash->error(Messages::error('edit', $this->texts['article_lower'], $this->texts['entity']));
            }
        }
        $roles = $this->Users->Roles->find('list', limit: 200)->all();
        $this->set(compact('user', 'roles'));
    }

    /**
     * Delete method
     *
     * @param string|null $id User id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $success = null;
        $this->viewBuilder()->setClassName('Ajax.Ajax');
        $this->request->allowMethod(['post', 'delete']);
        $user = $this->Users->get($id);
        if ($this->Users->delete($user))
        {
            $this->Flash->success(Messages::success('delete', $this->texts['article'], $this->texts['entity'],$this->texts['gender']));
            $success = true;
        } else
        {
            $this->Flash->error(Messages::error('delete', $this->texts['article_lower'], $this->texts['entity']));
            $success = false;
        }
        $this->set(compact('success'));
    }

    public function login()
    {
        $this->viewBuilder()->setLayout( 'admin/login' );
        $this->request->allowMethod(['get', 'post']);
        $result = $this->Authentication->getResult();
        // Sin importar si es POST o GET, redirige si el usuario esta autenticado
        if ($result->isValid()) {
            $user = $this->Authentication->getIdentity();
            if(!empty($this->menus[$user->role_id][0]['links'][0]['full_url']))
            {
                $redirect = $this->request->getQuery('redirect',$this->menus[$user->role_id][0]['links'][0]['full_url']);
                return $this->redirect($redirect);
            }
            $this->Flash->error(__('El Rol de usuario no ha sido configurado.'));
            return $this->logout();
        }
        // Muestra los errors si el usuario envió el formulario y fallo la autenticación
        if ($this->request->is('post') && !$result->isValid()) {
            $this->Flash->error(__('Usuario y/o contraseña no válida.'));
        }
    }

    public function logout()
    {
        $result = $this->Authentication->getResult();
        // Sin importar si es POST o GET, redirige si el usuario esta autenticado
        if ($result->isValid()) {
            $user = $this->Authentication->getIdentity();
            $url = ['controller' => 'Users', 'action' => 'login'];
            $this->Authentication->logout();
            return $this->redirect($url);
        }
    }
}
