<?php
declare(strict_types=1);

namespace App\Controller\Admin;
use Cake\Event\EventInterface;
use App\Text\Messages;

use App\Controller\AppController;

/**
 * Faculties Controller
 *
 * @property \App\Model\Table\FacultiesTable $Faculties
 */
class FacultiesController extends AppController
{
    public $texts;
    public function beforeFilter( EventInterface $event ) {
        parent::beforeFilter( $event );
        $this->viewBuilder()->setLayout('admin/default');
        $this->texts = [
            'article' => __('La'),
            'entity' => __('facultad'),
            'article_lower' => __('la'),
            'gender' => __('a')
        ];
    }
    /**
     * Index method
     *
     * @return \Cake\Http\Response|null|void Renders view
     */
    public function index()
    {

    }
    public function list(){
        $this->viewBuilder()->setLayout("ajax");
        $faculties = [];
        if($this->request->is("ajax"))
        {
            $conditions = [];
            $faculties = $this->Faculties->find('all',
                [
                    'fields' => [
                        'id',
                        'name'
                    ],
                    'conditions' => $conditions
                ]
            );
        }
        $this->response = $this->response->withType('json');
        $this->response = $this->response->withStringBody(json_encode(["data" => $faculties]));
        return $this->response;
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $this->viewBuilder()->setClassName('Ajax.Ajax');
        $faculty = $this->Faculties->newEmptyEntity();
        if ($this->request->is('post')) {
            $faculty = $this->Faculties->patchEntity($faculty, $this->request->getData());
            if ($this->Faculties->save($faculty))
            {
                $this->Flash->success(Messages::success('add', $this->texts['article'], $this->texts['entity'], $this->texts['gender']));
            }
            else
            {
                $this->Flash->error(Messages::error('add', $this->texts['article_lower'], $this->texts['entity']));
            }

        }
        $this->set(compact('faculty'));
    }

    /**
     * Edit method
     *
     * @param string|null $id Faculty id.
     * @return \Cake\Http\Response|null|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $this->viewBuilder()->setClassName('Ajax.Ajax');
        $faculty = $this->Faculties->get($id, contain: []);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $faculty = $this->Faculties->patchEntity($faculty, $this->request->getData());
            if ($this->Faculties->save($faculty))
            {
                $this->Flash->success(Messages::success('edit', $this->texts['article'], $this->texts['entity'], $this->texts['gender']));
            }
            else
            {
                $this->Flash->error(Messages::error('edit', $this->texts['article_lower'], $this->texts['entity']));
            }
        }
        $this->set(compact('faculty'));
    }

    /**
     * Delete method
     *
     * @param string|null $id Faculty id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $success = null;
        $this->viewBuilder()->setClassName('Ajax.Ajax');
        $this->request->allowMethod(['post', 'delete']);
        $faculty = $this->Faculties->get($id);
        if ($this->Faculties->delete($faculty)) {
            $this->Flash->success(Messages::success('delete', $this->texts['article'], $this->texts['entity'],$this->texts['gender']));
            $success = true;
        } else {
            $this->Flash->error(Messages::error('delete', $this->texts['article_lower'], $this->texts['entity']));
            $success = false;
        }
        $this->set(compact('success'));
    }
}
