var AppConFig = function(){

    let elementModal = document.querySelector('#editModal');
    this.modalEdit = new bootstrap.Modal(elementModal, {
        keyboard: false,
        backdrop: 'static'
    });
    this.htmlLoading = '<div class="d-flex justify-content-center align-items-center" style="min-height:200px;"><div class="spinner-border" role="status" style="width:2rem;height:2rem;color:#1d7187;"><span class="visually-hidden">Loading...</span></div></div>';
    this.contentModalContainer = $('#contentModal');
    // Data Table
    this.dataTableLengthMenu = [5, 10, 20, 50],
    this.dataTablePageLength = 20,
    this.dataTablePagingType = "simple_numbers",
    this.dataTableLanguageConfig = {
       "oPaginate": {
            "sPrevious": '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-arrow-left"><line x1="19" y1="12" x2="5" y2="12"></line><polyline points="12 19 5 12 12 5"></polyline></svg>',
            "sNext": '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-arrow-right"><line x1="5" y1="12" x2="19" y2="12"></line><polyline points="12 5 19 12 12 19"></polyline></svg>'
        },
        sInfo: "Mostrando página _PAGE_ of _PAGES_",
        sSearch: '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-search"><circle cx="11" cy="11" r="8"></circle><line x1="21" y1="21" x2="16.65" y2="16.65"></line></svg>',
        sSearchPlaceholder: "Buscar...",
        sProcessing:     "Procesando...",
        sLengthMenu:     "Mostrar _MENU_ registros",
        sZeroRecords:    "No se encontraron resultados",
        sEmptyTable:     "Ningún dato disponible en este módulo",
        sInfo:           "Mostrando registros del _START_ al _END_ de un total de _TOTAL_ registros",
        sInfoEmpty:      "Mostrando registros del 0 al 0 de un total de 0 registros",
        sInfoFiltered:   "(filtrado de un total de _MAX_ registros)",
        sInfoPostFix:    "",
        sSearch:         "Buscar:",
        sUrl:            "",
        sInfoThousands:  ",",
        sLoadingRecords: "Cargando...",
    }
    this.dataTableComplete = function() {
        $('#tableWrapper').show();
        $('#tableLoader').addClass('d-none');
    }
    // SweetAlert
    this.sweetAlertDeleteConfiguration = {
        title: '¿Está seguro?',
        text: "Realmente desea eliminar este registro.",
        icon: 'warning',
        customClass: {
            confirmButton: 'btn btn-primary',
            cancelButton: 'btn b-outline btn-light-outline bg-gray-50',
        },
        showCancelButton: true,
        confirmButtonText: 'Sí, eliminar',
        cancelButtonText: 'Cancelar',
        reverseButtons:true
    }
    this.processAjaxResponse = function(response, cbSuccess, cbError)
    {
        try{
            if(response._redirect.url)
            {
                location.href = response._redirect.url;
                return;
            }
        }
        catch(error)
        {
            // No existe redirección
        }
        const keyError = 'flash/error';
        const keySuccess = 'flash/success';
        let totalMessages = 0;
        let snackbarConfig = {
            actionText: 'Aceptar',
            actionTextColor: '#fff',
            pos: 'bottom-right'
        }
        try{
            totalMessages = response._message.length;
        }
        catch(err)
        {

        }
        if(totalMessages == 0)
        {
            return;
        }
        let error = false;
        for(let i=0; i<totalMessages; i++)
        {
            if(response._message[i].element == keyError)
            {
                snackbarConfig.backgroundColor = '#e7515a';
                error = true;
            }
            if(response._message[i].element == keySuccess)
            {
                snackbarConfig.backgroundColor = '#00ab55';
            }
            snackbarConfig.text = response._message[i].message,
            Snackbar.show(snackbarConfig);
        }
        if(error)
        {
            cbError();
            return;
        }
        cbSuccess();
    }
    this.ajaxCall = function(data, cbSuccess, cbError, cbAbort)
    {
        var ajax = new XMLHttpRequest();
        ajax.responseType = 'json';
        //Progress Listener
        ajax.upload.addEventListener("progress", function (e) {

        }, false);
        //Load Listener
        ajax.addEventListener("load", function (e) {
            cbSuccess(e.target.response)
        }, false);
        //Error Listener
        ajax.addEventListener("error", function (e) {
            cbError(e.target.response)
        }, false);
        //Abort Listener
        ajax.addEventListener("abort", function (e) {
            cbAbort(e.target.response)
        }, false);
        ajax.open(data.type, data.url);
        ajax.setRequestHeader('X-CSRF-Token',_csrfToken)
        ajax.setRequestHeader('X-Requested-With','XMLHttpRequest')
        ajax.setRequestHeader('Content-type', 'application/x-www-form-urlencoded');
        ajax.send(data.data);
    }
    this.callSelect2 =  function(){
        const singleSelects = document.querySelectorAll(".singleSelect");
        singleSelects.forEach((singleSelect) => {
            $(singleSelect).select2({
                width: "100%",
            });
        });
    }
    this.getHtmlActionsButtons =  function(id){
        // return '<div class="flex items-center gap-2"> <a href="javascript:void(0)" data-id="' + id + '" class="btnEdit btn-icon btn-primary-icon-light size-7"> <i class="ri-edit-line text-inherit text-[13px]"></i> </a><a href="javascript:void(0)" data-id="' + id + '" class="btnDelete btn-icon btn-danger-icon-light size-7"><i class="ri-delete-bin-line text-inherit text-[13px]"></i></a></div>';
        return ('<div class="d-inline-block">' +
        '<a href="javascript:;" class="btn btn-sm btn-icon dropdown-toggle hide-arrow" data-bs-toggle="dropdown"><i class="text-primary ti ti-dots-vertical"></i></a>' +
        '<ul class="dropdown-menu dropdown-menu-end m-0">' +
        '<li><a href="javascript:;" data-id="' + id + '" class="btnEdit dropdown-item">Editar</a></li>' +
        '<div class="dropdown-divider"></div>' +
        '<li><a href="javascript:;" data-id="' + id + '" class="btnDelete dropdown-item text-danger delete-record">Eliminar</a></li>' +
        '</ul>' +
        '</div>')
    }
    this.getLabelHtml = function(data){
        return '<span class="badge bg-label-success">' + data + '</span>';
    }

    this.registerListeners =  function(urlController, appConfig, dataTableList){
        $(document).on('click','#btnCancel',function(){
            appConfig.modalEdit.hide();
        });
        $(document).on('click','#btnAdd',function(){
            appConfig.modalEdit.show();
            appConfig.contentModalContainer.html(appConfig.htmlLoading);
            appConfig.ajaxCall({
                type:'get',
                url: urlController + '/add.json',
                data:{}
            },function(response)
            {
                if(response.content)
                {
                    appConfig.contentModalContainer.html(response.content);
                    appConfig.callSelect2();
                }
            },
            function(){

            },
            function(){

            }
            )
        });
        $(document).on('click','.btnEdit',function(){
            let id = $(this).data('id');
            if(!id)
            {
                return;
            }
            appConfig.modalEdit.show();
            appConfig.contentModalContainer.html(appConfig.htmlLoading);
            appConfig.ajaxCall({
                type:'get',
                url: urlController + '/edit/' + id + '.json',
                data:{}
            },
            function(response)
            {
                if(response.content)
                {
                    appConfig.contentModalContainer.html(response.content);
                    appConfig.callSelect2();
                }
            },
            function(){

            },
            function(){

            }
            )
        });
        $(document).on('click','#btnFormAdd',function(e){
            let btn = $(this);
            var buttonLoading =  new ButtonLoading(btn);
            buttonLoading.startLoading();
            let form = $('#formAdd');
            let isValid = form[0].checkValidity();
            if(!isValid)
            {
                buttonLoading.stopLoading();
                return;
            }
            e.preventDefault();
            appConfig.ajaxCall({
                type:'post',
                url: urlController + '/add.json',
                data:form.serialize()
            },function(response)
            {
                buttonLoading.stopLoading();
                appConfig.processAjaxResponse(response,function(){
                    appConfig.modalEdit.hide();
                    dataTableList.ajax.reload();
                },function(){
                    appConfig.contentModalContainer.html(response.content);
                    appConfig.callSelect2();
                });
            },
            function(){

            },
            function(){

            })
        });
        $(document).on('click','#btnFormEdit',function(e){
            let id = $(this).data('id');
            if(!id)
            {
                return;
            }
            let btn = $(this);
            var buttonLoading =  new ButtonLoading(btn);
            buttonLoading.startLoading();
            let form = $('#formEdit');
            let isValid = form[0].checkValidity();
            if(!isValid)
            {
                buttonLoading.stopLoading();
                return;
            }
            e.preventDefault();
            appConfig.ajaxCall({
                type:'post',
                url: urlController + '/edit/' + id + '.json',
                data:form.serialize()
            },function(response)
            {
                buttonLoading.stopLoading();
                appConfig.processAjaxResponse(response,function(){
                    appConfig.modalEdit.hide();
                    dataTableList.ajax.reload();
                },function(){
                    appConfig.contentModalContainer.html(response.content);
                    appConfig.callSelect2();
                });
            },
            function(){

            },
            function(){

            })
        });
        $(document).on('click','.btnDelete',function(){
            let id = $(this).data('id');
            if(!id)
            {
                return;
            }
            Swal.fire(appConfig.sweetAlertDeleteConfiguration).then((result) => {
                if (result.isConfirmed) {
                    appConfig.ajaxCall({
                        type:'post',
                        url: urlController + '/delete/' + id + '.json',
                        data:{}
                    },function(response)
                    {
                        appConfig.processAjaxResponse(response,function(){
                            dataTableList.ajax.reload();
                        },function(){
                        });
                    },
                    function(){

                    },
                    function(){

                    })
                }
            })
        });
    }
}
