<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Query\SelectQuery;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;
use App\Text\Messages;

/**
 * Faculties Model
 *
 * @property \App\Model\Table\CoodinationsTable&\Cake\ORM\Association\HasMany $Coodinations
 *
 * @method \App\Model\Entity\Faculty newEmptyEntity()
 * @method \App\Model\Entity\Faculty newEntity(array $data, array $options = [])
 * @method array<\App\Model\Entity\Faculty> newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Faculty get(mixed $primaryKey, array|string $finder = 'all', \Psr\SimpleCache\CacheInterface|string|null $cache = null, \Closure|string|null $cacheKey = null, mixed ...$args)
 * @method \App\Model\Entity\Faculty findOrCreate($search, ?callable $callback = null, array $options = [])
 * @method \App\Model\Entity\Faculty patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method array<\App\Model\Entity\Faculty> patchEntities(iterable $entities, array $data, array $options = [])
 * @method \App\Model\Entity\Faculty|false save(\Cake\Datasource\EntityInterface $entity, array $options = [])
 * @method \App\Model\Entity\Faculty saveOrFail(\Cake\Datasource\EntityInterface $entity, array $options = [])
 * @method iterable<\App\Model\Entity\Faculty>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\Faculty>|false saveMany(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\Faculty>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\Faculty> saveManyOrFail(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\Faculty>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\Faculty>|false deleteMany(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\Faculty>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\Faculty> deleteManyOrFail(iterable $entities, array $options = [])
 */
class FacultiesTable extends Table
{
    /**
     * Initialize method
     *
     * @param array<string, mixed> $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('faculties');
        $this->setDisplayField('name');
        $this->setPrimaryKey('id');
        $this->addBehavior('Register');

        $this->hasMany('Coodinations', [
            'foreignKey' => 'faculty_id',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator): Validator
    {
        $messageEmpty = Messages::get('REQUIRED');
        $validator
            ->scalar('name')
            ->maxLength('name', 255)
            ->requirePresence('name', 'create', $messageEmpty)
            ->notEmptyString('name', $messageEmpty);

        return $validator;
    }
}
