<?php
declare(strict_types=1);

namespace App\Model\Entity;

use Cake\ORM\Entity;
use Authentication\PasswordHasher\DefaultPasswordHasher;

/**
 * User Entity
 *
 * @property int $id
 * @property string $name
 * @property string $last_name
 * @property string|null $email
 * @property string $password
 * @property string $rut
 * @property int $role_id
 * @property bool $active
 * @property bool $change_password
 * @property string|null $reset_password_token
 * @property \Cake\I18n\DateTime|null $token_created_at
 * @property int $created_id
 * @property \Cake\I18n\DateTime $created_date
 * @property string $created_ip
 * @property int $modified_id
 * @property \Cake\I18n\DateTime $modified_date
 * @property string $modified_ip
 *
 * @property \App\Model\Entity\Role $role
 */
class User extends Entity
{
    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array<string, bool>
     */
    protected array $_accessible = [
        'name' => true,
        'last_name' => true,
        'email' => true,
        'password' => true,
        'rut' => true,
        'role_id' => true,
        'active' => true,
        'change_password' => true,
        'reset_password_token' => true,
        'token_created_at' => true,
        'created_id' => true,
        'created_date' => true,
        'created_ip' => true,
        'modified_id' => true,
        'modified_date' => true,
        'modified_ip' => true,
        'role' => true,
    ];

    /**
     * Fields that are excluded from JSON versions of the entity.
     *
     * @var list<string>
     */
    protected array $_hidden = [
        'password',
    ];
    protected array $_virtual = ['full_name'];

    protected function _setPassword(string $password) : ?string
    {
        if (strlen($password) > 0) {
            return (new DefaultPasswordHasher())->hash($password);
        }
        return '';
    }
    protected function _getFullName(): string
    {
        return $this->name . ' ' . $this->last_name;
    }
}
