$( document ).ready(function() {
    let dataTableList = null;
    let urlController = rootPath + 'admin/oportunidades';
    var appConfig =  new AppConFig();
    function loadDataTable(){
         dataTableList = $('#dataTableList').DataTable({
                order: [[0, 'desc']],
                autoWidth: false,
                responsive: true,
                destroy: true,
                ajax: {
                    url: urlController + '/list/' + status,
                },
                columns: [
                    {
                        data: 'id',
                        width: '80px'
                    },
                    {
                        data: 'nombre'
                    },
                    {
                        data: 'codigo_externo',
                    },
                    {
                        data: 'proyects',
                        render: function (data, type, row, meta) {
                            if(!row.projects || row.projects.length === 0)
                            {
                                return '--';
                            };
                            let html = '<ul>';
                            row.projects.forEach((item, index) => {
                                html += `<li>${item.empresa.nombre } / ${item.nombre }</li>`;
                            });
                            html += '</ul>';
                            return html;
                        }
                    },
                    {
                        data: 'words',
                        render: function (data, type, row, meta) {
                            let words = row.words
                            if(!words || Object.entries(words).length === 0)
                            {
                                return '--';
                            }
                            let html = '<ul>';
                            Object.entries(words).forEach(([key, value]) => {
                                 html += `<li>${value}</li>`;
                            });
                            html += '</ul>';
                            return html;
                            //return row.palabras_claves_licitacione.palabra_clave.palabra

                        }
                    },
                    {
                        data: 'id',
                        width: '80px',
                        render: function (data, type, row, meta) {
                            return appConfig.getHtmlActionsButtons(row.id);
                        }
                    },

                ],
                lengthMenu: appConfig.dataTableLengthMenu,
                pageLength: appConfig.dataTablePageLength,
                pagingType: appConfig.dataTablePagingType,
                language: appConfig.dataTableLanguageConfig,
        });
    }
    loadDataTable();
});
