var AppConFig = function(){

    this.modalEdit = new Modal(document.getElementById('editModal'),{
        backdrop: 'static'
    });
    this.htmlLoading = '<div class="text-center min-h-[200px] flex items-center justify-center"><div role="status"><svg aria-hidden="true" class="inline w-8 h-8 text-gray-200 animate-spin dark:text-gray-600" viewBox="0 0 100 101" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M100 50.5908C100 78.2051 77.6142 100.591 50 100.591C22.3858 100.591 0 78.2051 0 50.5908C0 22.9766 22.3858 0.59082 50 0.59082C77.6142 0.59082 100 22.9766 100 50.5908ZM9.08144 50.5908C9.08144 73.1895 27.4013 91.5094 50 91.5094C72.5987 91.5094 90.9186 73.1895 90.9186 50.5908C90.9186 27.9921 72.5987 9.67226 50 9.67226C27.4013 9.67226 9.08144 27.9921 9.08144 50.5908Z" fill="currentColor"/><path d="M93.9676 39.0409C96.393 38.4038 97.8624 35.9116 97.0079 33.5539C95.2932 28.8227 92.871 24.3692 89.8167 20.348C85.8452 15.1192 80.8826 10.7238 75.2124 7.41289C69.5422 4.10194 63.2754 1.94025 56.7698 1.05124C51.7666 0.367541 46.6976 0.446843 41.7345 1.27873C39.2613 1.69328 37.813 4.19778 38.4501 6.62326C39.0873 9.04874 41.5694 10.4717 44.0505 10.1071C47.8511 9.54855 51.7191 9.52689 55.5402 10.0491C60.8642 10.7766 65.9928 12.5457 70.6331 15.2552C75.2735 17.9648 79.3347 21.5619 82.5849 25.841C84.9175 28.9121 86.7997 32.2913 88.1811 35.8758C89.083 38.2158 91.5421 39.6781 93.9676 39.0409Z" fill="#1d7187"/></svg><span class="sr-only">Loading...</span></div></div>';
    this.contentModalContainer = $('#contentModal');
    // Data Table
    this.dataTableLengthMenu = [5, 10, 20, 50],
    this.dataTablePageLength = 20,
    this.dataTablePagingType = "simple_numbers",
    this.dataTableLanguageConfig = {
        paginate: {
            previous: "<i class='ri-arrow-left-line text-inherit'></i>",
            next: "<i class='ri-arrow-right-line text-inherit'></i>",
        },
        sInfo: "Mostrando página _PAGE_ of _PAGES_",
        sSearch: '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-search"><circle cx="11" cy="11" r="8"></circle><line x1="21" y1="21" x2="16.65" y2="16.65"></line></svg>',
        sSearchPlaceholder: "Buscar...",
        sProcessing:     "Procesando...",
        sLengthMenu:     "Mostrar _MENU_ registros",
        sZeroRecords:    "No se encontraron resultados",
        sEmptyTable:     "Ningún dato disponible en este módulo",
        sInfo:           "Mostrando registros del _START_ al _END_ de un total de _TOTAL_ registros",
        sInfoEmpty:      "Mostrando registros del 0 al 0 de un total de 0 registros",
        sInfoFiltered:   "(filtrado de un total de _MAX_ registros)",
        sInfoPostFix:    "",
        sSearch:         "Buscar:",
        sUrl:            "",
        sInfoThousands:  ",",
        sLoadingRecords: "Cargando...",
    }
    // SweetAlert
    this.sweetAlertDeleteConfiguration = {
        title: '¿Está seguro?',
        text: "Realmente desea eliminar este registro.",
        icon: 'warning',
        customClass: {
            confirmButton: 'btn b-solid btn-primary-solid',
            cancelButton: 'btn b-outline btn-light-outline bg-gray-50',
        },
        showCancelButton: true,
        confirmButtonText: 'Sí, eliminar',
        cancelButtonText: 'Cancelar',
        reverseButtons:true
    }
    this.processAjaxResponse = function(response, cbSuccess, cbError)
    {
        try{
            if(response._redirect.url)
            {
                location.href = response._redirect.url;
                return;
            }
        }
        catch(error)
        {
            // No existe redirección
        }
        const keyError = 'flash/error';
        const keySuccess = 'flash/success';
        let totalMessages = 0;
        let snackbarConfig = {
            actionText: 'Aceptar',
            actionTextColor: '#fff',
            pos: 'bottom-right'
        }
        try{
            totalMessages = response._message.length;
        }
        catch(err)
        {

        }
        if(totalMessages == 0)
        {
            return;
        }
        let error = false;
        for(let i=0; i<totalMessages; i++)
        {
            if(response._message[i].element == keyError)
            {
                snackbarConfig.backgroundColor = '#e7515a';
                error = true;
            }
            if(response._message[i].element == keySuccess)
            {
                snackbarConfig.backgroundColor = '#00ab55';
            }
            snackbarConfig.text = response._message[i].message,
            Snackbar.show(snackbarConfig);
        }
        if(error)
        {
            cbError();
            return;
        }
        cbSuccess();
    }
    this.ajaxCall = function(data, cbSuccess, cbError, cbAbort)
    {
        var ajax = new XMLHttpRequest();
        ajax.responseType = 'json';
        //Progress Listener
        ajax.upload.addEventListener("progress", function (e) {

        }, false);
        //Load Listener
        ajax.addEventListener("load", function (e) {
            cbSuccess(e.target.response)
        }, false);
        //Error Listener
        ajax.addEventListener("error", function (e) {
            cbError(e.target.response)
        }, false);
        //Abort Listener
        ajax.addEventListener("abort", function (e) {
            cbAbort(e.target.response)
        }, false);
        ajax.open(data.type, data.url);
        ajax.setRequestHeader('X-CSRF-Token',_csrfToken)
        ajax.setRequestHeader('X-Requested-With','XMLHttpRequest')
        ajax.setRequestHeader('Content-type', 'application/x-www-form-urlencoded');
        ajax.send(data.data);
    }
    this.callSelect2 =  function(){
        const singleSelects = document.querySelectorAll(".singleSelect");
        singleSelects.forEach((singleSelect) => {
            $(singleSelect).select2({
                width: "100%",
            });
        });
    }
    this.getHtmlActionsButtons =  function(id){
        return '<div class="flex items-center gap-2"> <a href="javascript:void(0)" data-id="' + id + '" class="btnEdit btn-icon btn-primary-icon-light size-7"> <i class="ri-edit-line text-inherit text-[13px]"></i> </a><a href="javascript:void(0)" data-id="' + id + '" class="btnDelete btn-icon btn-danger-icon-light size-7"><i class="ri-delete-bin-line text-inherit text-[13px]"></i></a></div>';
    }
    this.registerListeners =  function(urlController, appConfig, dataTableList){
        $(document).on('click','#btnCancel',function(){
            appConfig.modalEdit.hide();
        });
        $(document).on('click','#btnAdd',function(){
            appConfig.modalEdit.show();
            appConfig.contentModalContainer.html(appConfig.htmlLoading);
            appConfig.ajaxCall({
                type:'get',
                url: urlController + '/add.json',
                data:{}
            },function(response)
            {
                if(response.content)
                {
                    appConfig.contentModalContainer.html(response.content);
                    appConfig.callSelect2();
                }
            },
            function(){

            },
            function(){

            }
            )
        });
        $(document).on('click','.btnEdit',function(){
            let id = $(this).data('id');
            if(!id)
            {
                return;
            }
            appConfig.modalEdit.show();
            appConfig.contentModalContainer.html(appConfig.htmlLoading);
            appConfig.ajaxCall({
                type:'get',
                url: urlController + '/edit/' + id + '.json',
                data:{}
            },
            function(response)
            {
                if(response.content)
                {
                    appConfig.contentModalContainer.html(response.content);
                    appConfig.callSelect2();
                }
            },
            function(){

            },
            function(){

            }
            )
        });
        $(document).on('click','#btnFormAdd',function(e){
            let btn = $(this);
            var buttonLoading =  new ButtonLoading(btn);
            buttonLoading.startLoading();
            let form = $('#formAdd');
            let isValid = form[0].checkValidity();
            if(!isValid)
            {
                buttonLoading.stopLoading();
                return;
            }
            e.preventDefault();
            appConfig.ajaxCall({
                type:'post',
                url: urlController + '/add.json',
                data:form.serialize()
            },function(response)
            {
                buttonLoading.stopLoading();
                appConfig.processAjaxResponse(response,function(){
                    appConfig.modalEdit.hide();
                    dataTableList.ajax.reload();
                },function(){
                    appConfig.contentModalContainer.html(response.content);
                    appConfig.callSelect2();
                });
            },
            function(){

            },
            function(){

            })
        });
        $(document).on('click','#btnFormEdit',function(e){
            let id = $(this).data('id');
            if(!id)
            {
                return;
            }
            let btn = $(this);
            var buttonLoading =  new ButtonLoading(btn);
            buttonLoading.startLoading();
            let form = $('#formEdit');
            let isValid = form[0].checkValidity();
            if(!isValid)
            {
                buttonLoading.stopLoading();
                return;
            }
            e.preventDefault();
            appConfig.ajaxCall({
                type:'post',
                url: urlController + '/edit/' + id + '.json',
                data:form.serialize()
            },function(response)
            {
                buttonLoading.stopLoading();
                appConfig.processAjaxResponse(response,function(){
                    appConfig.modalEdit.hide();
                    dataTableList.ajax.reload();
                },function(){
                    appConfig.contentModalContainer.html(response.content);
                    appConfig.callSelect2();
                });
            },
            function(){

            },
            function(){

            })
        });
        $(document).on('click','.btnDelete',function(){
            let id = $(this).data('id');
            if(!id)
            {
                return;
            }
            Swal.fire(appConfig.sweetAlertDeleteConfiguration).then((result) => {
                if (result.isConfirmed) {
                    appConfig.ajaxCall({
                        type:'post',
                        url: urlController + '/delete/' + id + '.json',
                        data:{}
                    },function(response)
                    {
                        appConfig.processAjaxResponse(response,function(){
                            dataTableList.ajax.reload();
                        },function(){
                        });
                    },
                    function(){

                    },
                    function(){

                    })
                }
            })
        });
    }
}
