<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Query\SelectQuery;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * ProyectosPalabrasClavesLicitaciones Model
 *
 * @property \App\Model\Table\ProyectosTable&\Cake\ORM\Association\BelongsTo $Proyectos
 *
 * @method \App\Model\Entity\ProyectosPalabrasClavesLicitacione newEmptyEntity()
 * @method \App\Model\Entity\ProyectosPalabrasClavesLicitacione newEntity(array $data, array $options = [])
 * @method array<\App\Model\Entity\ProyectosPalabrasClavesLicitacione> newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\ProyectosPalabrasClavesLicitacione get(mixed $primaryKey, array|string $finder = 'all', \Psr\SimpleCache\CacheInterface|string|null $cache = null, \Closure|string|null $cacheKey = null, mixed ...$args)
 * @method \App\Model\Entity\ProyectosPalabrasClavesLicitacione findOrCreate($search, ?callable $callback = null, array $options = [])
 * @method \App\Model\Entity\ProyectosPalabrasClavesLicitacione patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method array<\App\Model\Entity\ProyectosPalabrasClavesLicitacione> patchEntities(iterable $entities, array $data, array $options = [])
 * @method \App\Model\Entity\ProyectosPalabrasClavesLicitacione|false save(\Cake\Datasource\EntityInterface $entity, array $options = [])
 * @method \App\Model\Entity\ProyectosPalabrasClavesLicitacione saveOrFail(\Cake\Datasource\EntityInterface $entity, array $options = [])
 * @method iterable<\App\Model\Entity\ProyectosPalabrasClavesLicitacione>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\ProyectosPalabrasClavesLicitacione>|false saveMany(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\ProyectosPalabrasClavesLicitacione>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\ProyectosPalabrasClavesLicitacione> saveManyOrFail(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\ProyectosPalabrasClavesLicitacione>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\ProyectosPalabrasClavesLicitacione>|false deleteMany(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\ProyectosPalabrasClavesLicitacione>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\ProyectosPalabrasClavesLicitacione> deleteManyOrFail(iterable $entities, array $options = [])
 */
class ProyectosPalabrasClavesLicitacionesTable extends Table
{
    /**
     * Initialize method
     *
     * @param array<string, mixed> $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('proyectos_palabras_claves_licitaciones');
        $this->setPrimaryKey('id');

        $this->belongsTo('Proyectos', [
            'foreignKey' => 'proyecto_id',
            'joinType' => 'INNER',
        ]);
        $this->belongsTo('PalabrasClavesLicitaciones', [
            'foreignKey' => 'palabra_clave_licitacion_id ',
            'joinType' => 'INNER',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator): Validator
    {
        $validator
            ->integer('proyecto_id')
            ->notEmptyString('proyecto_id');

        $validator
            ->integer('palabra_clave_licitacion_id')
            ->requirePresence('palabra_clave_licitacion_id', 'create')
            ->notEmptyString('palabra_clave_licitacion_id');



        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules): RulesChecker
    {
        $rules->add($rules->existsIn(['proyecto_id'], 'Proyectos'), ['errorField' => 'proyecto_id']);

        return $rules;
    }
    /**
     * Obtener agrupar y listar oportumidades
    */
    public function getOpportunities($status = 0){
        $conditions = [];
        if($status == 0)
        {
            $conditions['ProyectosPalabrasClavesLicitaciones.estado'] = 0;
        }
        else
        {
            $conditions['ProyectosPalabrasClavesLicitaciones.estado'] = $status;
        }
        // Obtener oportunidades
        $opportunities = $this->find('all',
            [
                'fields' => [
                    'id',
                    'proyecto_id',
                    'palabra_clave_licitacion_id'
                ],
                'conditions' => $conditions,
                'contain' => [
                    'PalabrasClavesLicitaciones' => [
                        'fields' => [
                            'id',
                            'licitacion_id',
                            'palabra_clave_id'
                        ],
                        'Licitaciones' => [
                            'fields' => [
                                'id',
                                'nombre',
                                'codigo_externo'
                            ],
                        ],
                        'PalabraClaves' => [
                            'fields' => [
                                'id',
                                'palabra',
                            ],
                        ]
                    ],
                    'Proyectos' => [
                        'fields' => [
                            'id',
                            'nombre',
                        ],
                        'Empresas' => [
                            'fields' => [
                                'id',
                                'nombre',
                                'correo',
                                'telefono',
                                'nombre_responsable'
                            ],
                            'conditions'=> [

                            ]
                        ]
                    ]
                ],
            ]
        );
        // Agrupar por Licitaciones
        $grouped = [];
        foreach ($opportunities as $opportunity) {
            $licitation = $opportunity->palabras_claves_licitacione->licitacione ?? null;
            if ($licitation) {
                $grouped[$licitation->id][] = $opportunity;
            }
        }
        $data = [];
        $dataEmail = [];
        foreach ($grouped as $licitationId => $opportunitiesGroup) {
            // Puedes tomar el primer registro del grupo como base
            $first = $opportunitiesGroup[0];
            $licitation = $first->palabras_claves_licitacione->licitacione;
            $project = $first->proyecto ?? null;
            $company = $proyecto->empresa ?? null;
            $projects = [];
            $words = [];
            foreach($opportunitiesGroup as $opportunity)
            {
                $projects[] = $opportunity->proyecto ?? null;
                $word = $opportunity->palabras_claves_licitacione->palabra_clave->palabra ?? null;
                $words[$opportunity->palabras_claves_licitacione->palabra_clave_id] =  $word;
                $dataEmail[$opportunity->proyecto->empresa->correo]['name'] = $opportunity->proyecto->empresa->nombre_responsable;
                $dataEmail[$opportunity->proyecto->empresa->correo]['licitations'][] = [
                    'licitation' => $licitation,
                    'word' => $word,
                    'project' => $opportunity->proyecto,
                ];
            }
            $data[] = [
                'id' => $licitation->id,
                'nombre' => $licitation->nombre,
                'codigo_externo' => $licitation->codigo_externo,
                'projects' => $projects,
                'words' => $words,
            ];
        }
        return [
            'data' => $data,
            'data_email' => $dataEmail,
        ];
    }
}
