<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Query\SelectQuery;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * PalabrasClaves Model
 *
 * @property \App\Model\Table\LicitacionesTable&\Cake\ORM\Association\BelongsToMany $Licitaciones
 * @property \App\Model\Table\ProyectosTable&\Cake\ORM\Association\BelongsToMany $Proyectos
 *
 * @method \App\Model\Entity\PalabrasClave newEmptyEntity()
 * @method \App\Model\Entity\PalabrasClave newEntity(array $data, array $options = [])
 * @method array<\App\Model\Entity\PalabrasClave> newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\PalabrasClave get(mixed $primaryKey, array|string $finder = 'all', \Psr\SimpleCache\CacheInterface|string|null $cache = null, \Closure|string|null $cacheKey = null, mixed ...$args)
 * @method \App\Model\Entity\PalabrasClave findOrCreate($search, ?callable $callback = null, array $options = [])
 * @method \App\Model\Entity\PalabrasClave patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method array<\App\Model\Entity\PalabrasClave> patchEntities(iterable $entities, array $data, array $options = [])
 * @method \App\Model\Entity\PalabrasClave|false save(\Cake\Datasource\EntityInterface $entity, array $options = [])
 * @method \App\Model\Entity\PalabrasClave saveOrFail(\Cake\Datasource\EntityInterface $entity, array $options = [])
 * @method iterable<\App\Model\Entity\PalabrasClave>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\PalabrasClave>|false saveMany(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\PalabrasClave>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\PalabrasClave> saveManyOrFail(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\PalabrasClave>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\PalabrasClave>|false deleteMany(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\PalabrasClave>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\PalabrasClave> deleteManyOrFail(iterable $entities, array $options = [])
 */
class PalabrasClavesTable extends Table
{
    /**
     * Initialize method
     *
     * @param array<string, mixed> $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('palabras_claves');
        $this->setDisplayField('palabra');
        $this->setPrimaryKey('id');
        $this->addBehavior('Register');

        $this->belongsToMany('Licitaciones', [
            'foreignKey' => 'palabra_clave_id',
            'targetForeignKey' => 'licitacion_id',
            'joinTable' => 'palabras_claves_licitaciones',
        ]);
        $this->belongsToMany('Proyectos', [
            'foreignKey' => 'palabra_clave_id',
            'targetForeignKey' => 'proyecto_id',
            'joinTable' => 'proyectos_palabras_claves',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator): Validator
    {
        $validator
            ->scalar('palabra')
            ->maxLength('palabra', 255)
            ->requirePresence('palabra', 'create')
            ->notEmptyString('palabra');

        return $validator;
    }
}
