<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Query\SelectQuery;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Licitaciones Model
 *
 * @property \App\Model\Table\PalabrasClavesTable&\Cake\ORM\Association\BelongsToMany $PalabrasClaves
 * @property \App\Model\Table\ProyectosPalabrasClavesTable&\Cake\ORM\Association\BelongsToMany $ProyectosPalabrasClaves
 *
 * @method \App\Model\Entity\Licitacione newEmptyEntity()
 * @method \App\Model\Entity\Licitacione newEntity(array $data, array $options = [])
 * @method array<\App\Model\Entity\Licitacione> newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Licitacione get(mixed $primaryKey, array|string $finder = 'all', \Psr\SimpleCache\CacheInterface|string|null $cache = null, \Closure|string|null $cacheKey = null, mixed ...$args)
 * @method \App\Model\Entity\Licitacione findOrCreate($search, ?callable $callback = null, array $options = [])
 * @method \App\Model\Entity\Licitacione patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method array<\App\Model\Entity\Licitacione> patchEntities(iterable $entities, array $data, array $options = [])
 * @method \App\Model\Entity\Licitacione|false save(\Cake\Datasource\EntityInterface $entity, array $options = [])
 * @method \App\Model\Entity\Licitacione saveOrFail(\Cake\Datasource\EntityInterface $entity, array $options = [])
 * @method iterable<\App\Model\Entity\Licitacione>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\Licitacione>|false saveMany(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\Licitacione>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\Licitacione> saveManyOrFail(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\Licitacione>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\Licitacione>|false deleteMany(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\Licitacione>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\Licitacione> deleteManyOrFail(iterable $entities, array $options = [])
 */
class LicitacionesTable extends Table
{
    /**
     * Initialize method
     *
     * @param array<string, mixed> $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('licitaciones');
        $this->setDisplayField('id');
        $this->setPrimaryKey('id');

        $this->belongsToMany('PalabrasClaves', [
            'foreignKey' => 'licitacion_id',
            'targetForeignKey' => 'palabras_clave_id',
            'joinTable' => 'palabras_claves_licitaciones',
        ]);
        $this->belongsToMany('ProyectosPalabrasClaves', [
            'foreignKey' => 'licitacion_id',
            'targetForeignKey' => 'proyectos_palabras_clave_id',
            'joinTable' => 'proyectos_palabras_claves_licitaciones',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator): Validator
    {
        $validator
            ->integer('modalidad_licitacion_id')
            ->notEmptyString('modalidad_licitacion_id');

        $validator
            ->integer('agil_id')
            ->notEmptyString('agil_id');

        $validator
            ->scalar('codigo_externo')
            ->maxLength('codigo_externo', 100)
            ->allowEmptyString('codigo_externo');

        $validator
            ->scalar('nombre')
            ->maxLength('nombre', 255)
            ->allowEmptyString('nombre');

        $validator
            ->boolean('estado_id')
            ->allowEmptyString('estado_id');

        $validator
            ->dateTime('fecha_cierre')
            ->allowEmptyDateTime('fecha_cierre');

        $validator
            ->scalar('fecha_proceso')
            ->maxLength('fecha_proceso', 10)
            ->allowEmptyString('fecha_proceso');

        $validator
            ->dateTime('fecha_creacion')
            ->notEmptyDateTime('fecha_creacion');

        $validator
            ->allowEmptyString('estado');

        return $validator;
    }
}
