<?php
declare(strict_types=1);

namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * Proyecto Entity
 *
 * @property int $id
 * @property int $empresa_id
 * @property string $nombre
 * @property string|null $descripcion
 * @property int $created_id
 * @property \Cake\I18n\DateTime $created_date
 * @property string $created_ip
 * @property int $modified_id
 * @property \Cake\I18n\DateTime $modified_date
 * @property string $modified_ip
 *
 * @property \App\Model\Entity\Empresa $empresa
 * @property \App\Model\Entity\PalabrasClave[] $palabras_claves
 */
class Proyecto extends Entity
{
    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array<string, bool>
     */
    protected array $_accessible = [
        'empresa_id' => true,
        'nombre' => true,
        'descripcion' => true,
        'activo' => true,
        'created_id' => true,
        'created_date' => true,
        'created_ip' => true,
        'modified_id' => true,
        'modified_date' => true,
        'modified_ip' => true,
        'empresa' => true,
        'palabras_claves' => true,
    ];
    public function getKeyWords()
    {
        if(empty($this->palabras_claves))
        {
            return[
                'array' => [],
                'str' => ''
            ];
        }
        $words = [];
        foreach($this->palabras_claves as $keyWord)
        {
            $words[] = $keyWord->palabra;
        }
        return [
            'array' => $words,
            'str' => implode(',',$words)
        ];
    }
}
