<?php
declare(strict_types=1);

namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * Empresa Entity
 *
 * @property int $id
 * @property string $nombre
 * @property int $created_id
 * @property \Cake\I18n\DateTime $created_date
 * @property string $created_ip
 * @property int $modified_id
 * @property \Cake\I18n\DateTime $modified_date
 * @property string $modified_ip
 *
 * @property \App\Model\Entity\Proyecto[] $proyectos
 * @property \App\Model\Entity\Usuario[] $usuarios
 */
class Empresa extends Entity
{
    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array<string, bool>
     */
    protected array $_accessible = [
        'nombre' => true,
        'correo' => true,
        'telefono' => true,
        'nombre_responsable' => true,
        'created_id' => true,
        'created_date' => true,
        'created_ip' => true,
        'modified_id' => true,
        'modified_date' => true,
        'modified_ip' => true,
        'proyectos' => true,
        'usuarios' => true,
    ];
}
