<?php
declare(strict_types=1);

namespace App\Controller\Admin;

use App\Controller\AppController;
use Cake\Event\EventInterface;
use App\Text\Messages;
use Cake\ORM\TableRegistry;


/**
 * Empresas Controller
 *
 * @property \App\Model\Table\EmpresasTable $Empresas
 */
class OportunidadesController extends AppController
{
    public $modelResults;
    public function beforeFilter( EventInterface $event ) {
        parent::beforeFilter( $event );
        $this->viewBuilder()->setLayout('admin/default');
        $this->modelResults = TableRegistry::getTableLocator()->get('ProyectosPalabrasClavesLicitaciones');
    }
    /**
     * Index method
     *
     * @return \Cake\Http\Response|null|void Renders view
     */
    public function index($status = 0)
    {
        $this->set(compact('status'));
    }
    public function list($status = 0){
        $this->viewBuilder()->setLayout("ajax");
        $opportunities = [];
        if($this->request->is("ajax"))
        {
            $opportunities = $this->modelResults->getOpportunities($status);
        }
        $this->response = $this->response->withType('json');
        $this->response = $this->response->withStringBody(json_encode(["data" => $opportunities['data']]));
        return $this->response;
    }

}
